/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2004 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Drawing;
using System.Drawing.Design;
using System.Text;


namespace Borland.Data.Web
{

   #region DBWebTextBox

	/// <summary>
	/// Data aware TextBox control for use with DBWebDataSource
	/// </summary>
	[Designer("Borland.Data.Web.DBWebControlDesigner"),
   ToolboxBitmap(typeof(Borland.Data.Web.DBWebTextBox),
   "Borland.Data.Web.DBWebTextBox.bmp"),
   ToolboxData("<{0}:DBWebTextBox runat=server></{0}:DBWebTextBox>")]
   public class DBWebTextBox : TextBox, IDBWebColumnLink, IPostBackDataHandler
   {
   	private const string childPrefix = "TB_";
      private DBWebColumnLink FColumnLink;
      private IDBWebColumnLink IColumnLink;

   	public DBWebTextBox() : base()
      {
         FColumnLink = new DBWebColumnLink(this);
         IColumnLink = (FColumnLink as IDBWebColumnLink);
      }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
      }


      #region IDBWebDataLink
      string IDBWebDataLink.TableName
      {
      	get
         {
         	return IColumnLink.TableName;
         }
         set
         {
         	IColumnLink.TableName = value;
         }
      }
      IDBDataSource IDBWebDataLink.DBDataSource
      {
      	get
         {
         	return IColumnLink .DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }
      #endregion
      #region IDBWebColumnLink
      string IDBWebColumnLink.ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
      #endregion

      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }


      [Editor(typeof(Borland.Data.Web.ColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }

      protected string ChildPrefix
      {
      	get
         {
         	return childPrefix;
         }
      }

      #region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
	      	FColumnLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
	   }
      #endregion

		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
         if( s != null )
         	return;
         DataBind();
         if( !ReadOnly )
         	Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + this.ID, IColumnLink.TableName + DBWebConst.Splitter + IColumnLink.ColumnName);
		}

 		protected override void Render(HtmlTextWriter output)
		{
      	bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
         if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
         	base.Render(output);
         else  // if going to a separate error hmtl page, output "OK" button.
         {
         	ClassUtils.OutputOKButton(output);
            Page.Response.End();
         }
		}

		public override void DataBind()
      {
      	try
         {
	         if( !FColumnLink.IsDataBound )
   	      	this.Text = null;
      	   base.DataBind();
      		if( FColumnLink.IsDataBound )
      	   {
	            Object o = IColumnLink.DBDataSource.GetColumnValue(Page,
   	         					IColumnLink.TableName, IColumnLink.ColumnName);
         	   string text = "";
            	if( o != null )
            		text = o.ToString();
	            this.Text = text;
   	         base.DataBind();
            }
         }
         catch(Exception ex)
         {
         	if( !ClassUtils.IsDesignTime(Page) )
            {
	            Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
            }
            else
            	throw new Exception(ex.Message);
         }
      }
   }
   #endregion

   #region DBWebLabel

  	/// <summary>
	/// Data aware Asp Label control for use with DBWebDataSource
	/// </summary>

	[Designer("Borland.Data.Web.DBWebControlDesigner"),
	ToolboxData("<{0}:DBWebLabel runat=server></{0}:DBWebLabel>")]
   public class DBWebLabel : Label, IDBWebColumnLink, IPostBackDataHandler
   {
   	private const string childPrefix = "TB_";
      private DBWebColumnLink FColumnLink;
      private IDBWebColumnLink IColumnLink;
      private const int minLabelWidth = 100;

   	public DBWebLabel() : base()
      {
         FColumnLink = new DBWebColumnLink(this);
         IColumnLink = (FColumnLink as IDBWebColumnLink);
      }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
      }

      #region IDBWebDataLink
      string IDBWebDataLink.TableName
      {
      	get
         {
         	return IColumnLink.TableName;
         }
         set
         {
         	IColumnLink.TableName = value;
         }
      }
      IDBDataSource IDBWebDataLink.DBDataSource
      {
      	get
         {
         	return IColumnLink .DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }
      #endregion
      #region IDBWebColumnLink
      string IDBWebColumnLink.ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
      #endregion

      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }


      [Editor(typeof(Borland.Data.Web.ColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }

      protected string ChildPrefix
      {
      	get
         {
         	return childPrefix;
         }
      }

      #region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
	      	FColumnLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
	   }
      #endregion

		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
         if( s != null )
         	return;
         DataBind();
		}

 		protected override void Render(HtmlTextWriter output)
		{
      	bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
         if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
         	base.Render(output);
         else  // if going to a separate error hmtl page, output "OK" button.
         {
         	ClassUtils.OutputOKButton(output);
            Page.Response.End();
         }
		}

		public override void DataBind()
      {
      	try
         {
	         if( !FColumnLink.IsDataBound )
   	      {
      	      if( ClassUtils.IsDesignTime(Page) )
				  if( this.Width.Value < new Unit(minLabelWidth).Value)
         			   this.Width = new Unit(minLabelWidth);
         		this.Text = null;
	         }
   	      base.DataBind();
      		if( FColumnLink.IsDataBound )
         	{
            	Object o = IColumnLink.DBDataSource.GetColumnValue(Page,
            					IColumnLink.TableName, IColumnLink.ColumnName);
	            string text = "";
   	         if( o != null )
      	      	text = o.ToString();
         	   this.Text = text;
            	base.DataBind();
            }
         }
         catch(Exception ex)
         {
         	if( !ClassUtils.IsDesignTime(Page) )
            {
	            Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
            }
            else
            	throw new Exception(ex.Message);
         }
      }
   }
   #endregion
}
